//
//  BallViewController.m
//  Ball
//
//  Created by Robert Górczyński on 11-07-29.
//

#import "BallViewController.h"
#import "BallView.h" 

@implementation BallViewController
@synthesize motionManager; 

- (void)viewDidLoad { 
    self.motionManager = [[[CMMotionManager alloc] init] autorelease]; 
    NSOperationQueue *queue = [[[NSOperationQueue alloc] init] autorelease]; 
    motionManager.accelerometerUpdateInterval = kUpdateInterval; 
    [motionManager startAccelerometerUpdatesToQueue:queue withHandler: 
     ^(CMAccelerometerData *accelerometerData, NSError *error) {  
         [(BallView *)self.view setAcceleration:accelerometerData.acceleration]; 
         [(BallView *)self.view performSelectorOnMainThread:@selector(draw)  
												 withObject:nil waitUntilDone:NO]; 
     }]; 
    [super viewDidLoad]; 
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
